<Query Kind="Program">
  <Namespace>System.Diagnostics.Tracing</Namespace>
</Query>

// This program is intentially written to perform poorly. You can run it while experimenting with the diagnostics techniques described in Chapter 13.

void Main()
{
	// Narzędzia diagnostyczne potrzebują identyfikatora procesu:
	Console.WriteLine ($"Identyfikator procesu  {Process.GetCurrentProcess().Id}");
	Console.WriteLine("Odczekanie 10 sekund.");
	Thread.Sleep(10000);
	Console.WriteLine(MaxSubarraySlow(LongRandomArray(7000))); // Dla wartości 7000 obliczenia trwają 1-2 minuty na nowoczesnym sprzęcie
}

// Ta niewydajna implementacja problemu maksymalnej podtablicy ma złożonośc obliczeniową O(n^3)
// Algorytm Kadane'a ma złożoność O(n).
// Ta metoda oblicza największą sumę, jaką można uzyskać przez dodanie wartości dwóch kolejnych indeksów tablicy.
int MaxSubarraySlow (int[] array)
{
	if (array?.Count() == 0) throw new ArgumentException ("Tablica musi zawierać elementy.");

	Stopwatch maxTimer = Stopwatch.StartNew();
	int highestSum = int.MinValue;
	for (int i = 0; i < array.Length; i++) // Lewy brzeg podtablicy
		for (int j = i + 1; j < array.Length; j++) // Prawy brzeg podtablicy
		{
			int subarraySum = 0;
			for (int n = i; n <= j; n++) subarraySum += array [n];
			highestSum = Math.Max (highestSum, subarraySum);
			if (subarraySum == highestSum) // Znaleziono maksimum (może być równe poprzedniemu)
			{
				MyEventCounterSource.Log.Request (highestSum, maxTimer.ElapsedMilliseconds);
				maxTimer.Restart();
			}
		}
	return highestSum;
}

int [] LongRandomArray (int size)
{
	return Enumerable.Repeat (0, size).Select (i => rnd.Next()).ToArray();
}

Random rnd = new Random();

[EventSource (Name = "My-Subarray-MaxUpdated")]
public sealed class MyEventCounterSource : EventSource
{
	public static MyEventCounterSource Log = new MyEventCounterSource();
	private EventCounter requestCounter;

	private MyEventCounterSource() : base (EventSourceSettings.EtwSelfDescribingEventFormat)
	{
		this.requestCounter = new EventCounter ("Highest sum updated", this);
	}

	public void Request (int currentMax, float elapsedMSec)
	{
		WriteEvent (1, currentMax, elapsedMSec);
		this.requestCounter.WriteMetric (elapsedMSec);
	}
}